using System.IO;
using UnrealBuildTool;

public class AccessControlLibrary : ModuleRules
{
    public AccessControlLibrary(ReadOnlyTargetRules Target) : base(Target)
    {
        Type = ModuleType.External;

        ConfigureDependencies();
    }

    public string GetLibraryDirectory()
    {
        return Path.Combine(ModuleDirectory, "x64");
    }

    private void ConfigureDependencies()
    {
        string libraryDirectory = GetLibraryDirectory();

        PublicAdditionalLibraries.Add(Path.Combine(libraryDirectory, "Innoactive.Portal.AccessControl.Launcher.CppBridge.lib"));

        string[] libraryPaths = Directory.GetFiles(libraryDirectory);
        foreach (string libraryPath in libraryPaths)
        {
            if (Path.GetExtension(libraryPath) == ".dll")
            {
                string fileName = Path.GetFileName(libraryPath);

                RuntimeDependencies.Add(Path.Combine("$(TargetOutputDir)", fileName), libraryPath);
                PublicDelayLoadDLLs.Add(fileName);
            }
        }
    }
}
